﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Drawing.Drawing2D
Imports System.Drawing.Text

Public Class MainForm

    Const WinkTimerInterval As Integer = 150 ' 以毫秒计
    Protected eyeImages(4) As Image
    Protected currentImage As Integer = 0
    Protected animationStep As Integer = 1

    Const BallTimerInterval As Integer = 25 ' 以毫秒计
    Private ballSize As Integer = 16 ' 作为工作区的等份数
    Private moveSize As Integer = 4 ' 作为球大小的等份数
    Private bitmap As Bitmap
    Private ballPositionX As Integer
    Private ballPositionY As Integer
    Private ballRadiusX As Integer
    Private ballRadiusY As Integer
    Private ballMoveX As Integer
    Private ballMoveY As Integer
    Private ballBitmapWidth As Integer
    Private ballBitmapHeight As Integer
    Private bitmapWidthMargin As Integer
    Private bitmapHeightMargin As Integer

    Const TextTimerInterval As Integer = 15 ' 以毫秒计
    Protected currentGradientShift As Integer = 10
    Protected gradiantStep As Integer = 5

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 为 Winking Eye 示例填充图像数组。
        eyeImages(0) = My.Resources.Eye1
        eyeImages(1) = My.Resources.Eye2
        eyeImages(2) = My.Resources.Eye3
        eyeImages(3) = My.Resources.Eye4
    End Sub

    Private Sub RadioButtons_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles optWink.CheckedChanged, optBall.CheckedChanged
        If optWink.Checked Then
            tmrAnimation.Interval = WinkTimerInterval
        ElseIf optBall.Checked Then
            tmrAnimation.Interval = BallTimerInterval
        ElseIf optText.Checked Then
            tmrAnimation.Interval = TextTimerInterval
        End If

        OnResize(EventArgs.Empty)
    End Sub

    Protected Overridable Sub TimerOnTick(ByVal obj As Object, ByVal ea As EventArgs) Handles tmrAnimation.Tick
        If optWink.Checked Then

            ' 获得窗体公开的 Graphics 对象。
            Dim grfx As Graphics = CreateGraphics()

            ' 使用第 8 个重载调用 DrawImage，该重载使用的参数为要显示的
            ' 当前图像、X 和 Y 坐标（该坐标在此例中使图像
            ' 在工作区居中）以及图像的宽和高。
            grfx.DrawImage(eyeImages(currentImage), _
                CInt((ClientSize.Width - eyeImages(currentImage).Width) / 2), _
                CInt((ClientSize.Height - eyeImages(currentImage).Height) / 2), _
                eyeImages(currentImage).Width, _
                eyeImages(currentImage).Height)
            ' 为公开此方法的对象调用 Dispose，而不是
            ' 等待垃圾回收器自动回收，这始终是一个好主意。
            ' 这样几乎总可以提高应用程序的性能。
            grfx.Dispose()

            ' 循环遍历图像。
            currentImage += animationStep
            If currentImage = 3 Then
                ' 这是四个图像中的最后一个，因此反转动画顺序
                ' 以使眼睛闭上。
                animationStep = -1
            ElseIf currentImage = 0 Then
                ' 这是四个图像中的第一个，因此反转动画顺序
                ' 以使眼睛再次睁开。
                animationStep = 1
            End If

        ElseIf optBall.Checked Then

            ' 获得窗体公开的 Graphics 对象。
            Dim grfx As Graphics = CreateGraphics()
            ' 绘制包含窗体上的球的位图。
            grfx.DrawImage(bitmap, _
                CInt(ballPositionX - ballBitmapWidth / 2), _
                CInt(ballPositionY - ballBitmapHeight / 2), _
                ballBitmapWidth, ballBitmapHeight)

            grfx.Dispose()

            ' 递增球的位置，每次的幅度为球在重绘之后在
            ' X 和 Y 方向移动的距离。
            ballPositionX += ballMoveX
            ballPositionY += ballMoveY

            ' 在球触及边界时反转球的方向。
            If ballPositionX + ballRadiusX >= ClientSize.Width _
                Or ballPositionX - ballRadiusX <= 0 Then
                ballMoveX = -ballMoveX
                Beep()
            End If
            ' 将 Y 边界设置为 80 而不是 0，以便球不会弹入
            ' 窗体上的控件中。
            If ballPositionY + ballRadiusY >= ClientSize.Height _
                Or ballPositionY - ballRadiusY <= 80 Then
                ballMoveY = -ballMoveY
                Beep()
            End If

        ElseIf optText.Checked Then

            ' 获得窗体公开的 Graphics 对象。
            Dim grfx As Graphics = CreateGraphics()

            ' 设置字体类型、文本，并确定其大小。
            Dim font As New Font("Microsoft Sans Serif", 96, _
                FontStyle.Bold, GraphicsUnit.Point)
            Dim strText As String = "GDI+!"
            Dim sizfText As New SizeF(grfx.MeasureString(strText, font))

            ' 设置将在其上绘制文本的点：在
            ' 工作区中居中。
            Dim ptfTextStart As New PointF( _
                CSng(ClientSize.Width - sizfText.Width) / 2, _
                CSng(ClientSize.Height - sizfText.Height) / 2)

            ' 设置渐变起点和终点，后者通过
            ' 一个不断变化的值进行调整以产生动画效果。
            Dim ptfGradientStart As New PointF(0, 0)
            Dim ptfGradientEnd As New PointF(currentGradientShift, 200)

            ' 实例化用于绘制文本的画笔。
            Dim grBrush As New LinearGradientBrush(ptfGradientStart, _
                ptfGradientEnd, Color.Blue, BackColor)

            ' 在工作区居中位置绘制文本。
            grfx.DrawString(strText, font, grBrush, ptfTextStart)

            grfx.Dispose()

            ' 变换渐变，在它达到一定值时将其反转。
            currentGradientShift += gradiantStep
            If currentGradientShift = 500 Then
                gradiantStep = -5
            ElseIf currentGradientShift = -50 Then
                gradiantStep = 5
            End If
        End If
    End Sub

    ' 此方法重写 Control 基类中的 OnResize 方法。OnResize 
    ' 引发 Resize 事件，该事件在调整控件（在此例中为 
    ' 窗体）大小时发生。
    Protected Overrides Sub OnResize(ByVal ea As EventArgs)
        If optWink.Checked Then

            ' 获得窗体公开的 Graphics 对象并清除所有绘制内容。
            Dim grfx As Graphics = CreateGraphics()
            ' 还可以调用 grfx.Clear(BackColor) 或 Me.Invalidate() 清除
            ' 屏幕。
            Me.Refresh()
            grfx.Dispose()

        ElseIf optBall.Checked Then

            ' 获得窗体公开的 Graphics 对象并清除所有绘制内容。
            Dim grfx As Graphics = CreateGraphics()
            grfx.Clear(BackColor)

            ' 将球的半径设置为工作区的宽度或高度
            ' （取较小的）的每一等份的大小。
            Dim dblRadius As Double = Math.Min(ClientSize.Width / grfx.DpiX, _
                ClientSize.Height / grfx.DpiY) / ballSize

            ' 设置球的宽度和高度，使得在大多数情况下，DPI
            ' 在 X 轴和 Y 轴方向是完全相同的。
            ballRadiusX = CInt(dblRadius * grfx.DpiX)
            ballRadiusY = CInt(dblRadius * grfx.DpiY)

            grfx.Dispose()

            ' 将球移动的距离设置为 1 个像素或球尺寸
            ' 的每一等份的大小（取其中较大的那一个）。这意味着球在
            ' 每次绘制时移动的距离与其大小是成正比的，球的大小反过来又与
            ' 工作区的大小成正比。因此，当
            ' 工作区收缩时，球将变慢，当工作区放大时
            ' 球将变快。
            ballMoveX = CInt(Math.Max(1, ballRadiusX / moveSize))
            ballMoveY = CInt(Math.Max(1, ballRadiusY / moveSize))

            ' 注意球移动的值还作为
            ' 球周围的边距，该边距确定用于绘制球的实际位图
            ' 的大小。因此，球移动的距离
            ' 正好等于位图的大小，从而允许在绘制 
            ' 下一个图像之前清除球的前一个图像，而这一切
            ' 都不会导致闪烁次数过多。
            bitmapWidthMargin = ballMoveX
            bitmapHeightMargin = ballMoveY

            ' 通过将边距添加到球的尺寸上，确定用于绘制
            ' 球的位图的实际大小。
            ballBitmapWidth = 2 * (ballRadiusX + bitmapWidthMargin)
            ballBitmapHeight = 2 * (ballRadiusY + bitmapHeightMargin)

            ' 创建一个新位图，并传入宽度和高度
            bitmap = New Bitmap(ballBitmapWidth, ballBitmapHeight)

            ' 获得位图公开的 Graphics 对象，清除现有的 
            ' 球，并绘制新的球。
            grfx = Graphics.FromImage(bitmap)
            With grfx
                .Clear(BackColor)
                .FillEllipse(Brushes.Red, New Rectangle(ballMoveX, _
                    ballMoveY, 2 * ballRadiusX, 2 * ballRadiusY))
                .Dispose()
            End With

            ' 将球的位置重置为工作区的中心。
            ballPositionX = CInt(ClientSize.Width / 2)
            ballPositionY = CInt(ClientSize.Height / 2)

        ElseIf optText.Checked Then
            ' 获得窗体公开的 Graphics 对象并清除所有绘制内容。
            Dim grfx As Graphics = CreateGraphics()
            grfx.Clear(BackColor)
        End If
    End Sub


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class